﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace Darkminer_v6
{
	// Token: 0x0200003F RID: 63
	[DesignerGenerated]
	public partial class Form6 : Form
	{
		// Token: 0x0600027B RID: 635 RVA: 0x000154CC File Offset: 0x000136CC
		public Form6()
		{
			base.Load += this.Form6_Load;
			this.cancellationTokenSource = new CancellationTokenSource();
			this.random = new Random();
			this.tries = 0;
			this.isMining = false;
			this.foundCount = 0;
			this.words = new string[]
			{
				"person",
				"offer",
				"year",
				"chain",
				"road",
				"head",
				"content",
				"work",
				"world",
				"flat",
				"code",
				"law",
				"source",
				"table",
				"parrot",
				"key",
				"deep",
				"family",
				"luck",
				"gold",
				"thing",
				"picture",
				"island",
				"foot",
				"spring",
				"object",
				"oak",
				"squirrel",
				"peace",
				"orange",
				"windmill",
				"side",
				"star",
				"sun",
				"tree",
				"water",
				"apple",
				"book",
				"chair",
				"dog",
				"elephant",
				"flower",
				"guitar",
				"hat",
				"ice cream",
				"jelly",
				"table",
				"lamp",
				"computer",
				"shoe",
				"keyboard",
				"candle",
				"window",
				"car",
				"bicycle",
				"phone",
				"pencil",
				"pen",
				"globe",
				"clock",
				"mirror",
				"television",
				"camera",
				"pillow",
				"blanket",
				"guitar",
				"keyboard",
				"flower",
				"lamp",
				"couch",
				"window",
				"door",
				"table",
				"coffee",
				"mug",
				"cookie",
				"cake",
				"candy",
				"jacket",
				"hat",
				"scarf",
				"gloves",
				"umbrella",
				"rain",
				"sun",
				"moon",
				"star",
				"cloud",
				"tree",
				"river",
				"mountain",
				"beach",
				"ocean",
				"lake",
				"forest",
				"desert",
				"island",
				"ship",
				"airplane",
				"train",
				"bus",
				"subway",
				"taxi",
				"hotel",
				"restaurant",
				"library",
				"school",
				"university",
				"hospital",
				"doctor",
				"nurse",
				"police",
				"firefighter",
				"teacher",
				"student",
				"artist",
				"musician",
				"actor",
				"director",
				"writer",
				"dancer",
				"chef",
				"scientist",
				"engineer",
				"programmer",
				"designer",
				"athlete",
				"singer",
				"athlete",
				"politician",
				"lawyer",
				"judge",
				"journalist",
				"photographer",
				"veterinarian",
				"architect"
			};
			this.textBuilder = new StringBuilder();
			this.InitializeComponent();
		}

		// Token: 0x170000BE RID: 190
		// (get) Token: 0x0600027E RID: 638 RVA: 0x0000357E File Offset: 0x0000177E
		// (set) Token: 0x0600027F RID: 639 RVA: 0x00016500 File Offset: 0x00014700
		internal virtual Button StartButton
		{
			[CompilerGenerated]
			get
			{
				return this._StartButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StartButton_Click);
				Button startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click -= value2;
				}
				this._StartButton = value;
				startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click += value2;
				}
			}
		}

		// Token: 0x170000BF RID: 191
		// (get) Token: 0x06000280 RID: 640 RVA: 0x00003588 File Offset: 0x00001788
		// (set) Token: 0x06000281 RID: 641 RVA: 0x00016544 File Offset: 0x00014744
		internal virtual Button StopButton
		{
			[CompilerGenerated]
			get
			{
				return this._StopButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StopButton_Click);
				Button stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click -= value2;
				}
				this._StopButton = value;
				stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click += value2;
				}
			}
		}

		// Token: 0x170000C0 RID: 192
		// (get) Token: 0x06000282 RID: 642 RVA: 0x00003592 File Offset: 0x00001792
		// (set) Token: 0x06000283 RID: 643 RVA: 0x0000359C File Offset: 0x0000179C
		internal virtual RichTextBox ResultRichTextBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C1 RID: 193
		// (get) Token: 0x06000284 RID: 644 RVA: 0x000035A5 File Offset: 0x000017A5
		// (set) Token: 0x06000285 RID: 645 RVA: 0x000035AF File Offset: 0x000017AF
		internal virtual CheckBox EthCheckBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C2 RID: 194
		// (get) Token: 0x06000286 RID: 646 RVA: 0x000035B8 File Offset: 0x000017B8
		// (set) Token: 0x06000287 RID: 647 RVA: 0x000035C2 File Offset: 0x000017C2
		internal virtual Label RecordCountLabel { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C3 RID: 195
		// (get) Token: 0x06000288 RID: 648 RVA: 0x000035CB File Offset: 0x000017CB
		// (set) Token: 0x06000289 RID: 649 RVA: 0x000035D5 File Offset: 0x000017D5
		internal virtual RichTextBox Izpis { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C4 RID: 196
		// (get) Token: 0x0600028A RID: 650 RVA: 0x000035DE File Offset: 0x000017DE
		// (set) Token: 0x0600028B RID: 651 RVA: 0x000035E8 File Offset: 0x000017E8
		internal virtual Label Found { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C5 RID: 197
		// (get) Token: 0x0600028C RID: 652 RVA: 0x000035F1 File Offset: 0x000017F1
		// (set) Token: 0x0600028D RID: 653 RVA: 0x000035FB File Offset: 0x000017FB
		internal virtual PictureBox PictureBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C6 RID: 198
		// (get) Token: 0x0600028E RID: 654 RVA: 0x00003604 File Offset: 0x00001804
		// (set) Token: 0x0600028F RID: 655 RVA: 0x0000360E File Offset: 0x0000180E
		internal virtual PictureBox PictureBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C7 RID: 199
		// (get) Token: 0x06000290 RID: 656 RVA: 0x00003617 File Offset: 0x00001817
		// (set) Token: 0x06000291 RID: 657 RVA: 0x00003621 File Offset: 0x00001821
		internal virtual PictureBox PictureBox3 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C8 RID: 200
		// (get) Token: 0x06000292 RID: 658 RVA: 0x0000362A File Offset: 0x0000182A
		// (set) Token: 0x06000293 RID: 659 RVA: 0x00003634 File Offset: 0x00001834
		internal virtual PictureBox PictureBox6 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000C9 RID: 201
		// (get) Token: 0x06000294 RID: 660 RVA: 0x0000363D File Offset: 0x0000183D
		// (set) Token: 0x06000295 RID: 661 RVA: 0x00003647 File Offset: 0x00001847
		internal virtual CheckBox CheckBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000CA RID: 202
		// (get) Token: 0x06000296 RID: 662 RVA: 0x00003650 File Offset: 0x00001850
		// (set) Token: 0x06000297 RID: 663 RVA: 0x0000365A File Offset: 0x0000185A
		internal virtual CheckBox CheckBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000CB RID: 203
		// (get) Token: 0x06000298 RID: 664 RVA: 0x00003663 File Offset: 0x00001863
		// (set) Token: 0x06000299 RID: 665 RVA: 0x0000366D File Offset: 0x0000186D
		internal virtual CheckBox CheckBox3 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000CC RID: 204
		// (get) Token: 0x0600029A RID: 666 RVA: 0x00003676 File Offset: 0x00001876
		// (set) Token: 0x0600029B RID: 667 RVA: 0x00003680 File Offset: 0x00001880
		private virtual System.Windows.Forms.Timer timer { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x0600029C RID: 668 RVA: 0x00016588 File Offset: 0x00014788
		private void Form6_Load(object sender, EventArgs e)
		{
			this.ResultRichTextBox.ReadOnly = true;
			this.ResultRichTextBox.BackColor = Color.Black;
			this.ResultRichTextBox.Font = new Font(SystemFonts.DefaultFont.FontFamily, 12f);
			this.ResultRichTextBox.WordWrap = false;
			System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
			timer.Tick += this.InternetCheckTimer_Tick;
			timer.Interval = 5000;
			timer.Start();
		}

		// Token: 0x0600029D RID: 669 RVA: 0x00016610 File Offset: 0x00014810
		private void InternetCheckTimer_Tick(object sender, EventArgs e)
		{
			bool flag = this.CheckForInternetConnection();
			bool flag2 = !flag;
			if (flag2)
			{
				this.StopMining();
			}
		}

		// Token: 0x0600029E RID: 670 RVA: 0x00016638 File Offset: 0x00014838
		private void StopMining()
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x0600029F RID: 671 RVA: 0x000166A4 File Offset: 0x000148A4
		private void AppendTextWithScroll(string text, Color color, bool isBold, float fontSize)
		{
			bool invokeRequired = this.ResultRichTextBox.InvokeRequired;
			if (invokeRequired)
			{
				this.ResultRichTextBox.Invoke(delegate()
				{
					this.AppendTextWithScroll(text, color, isBold, fontSize);
				});
			}
			else
			{
				this.ResultRichTextBox.SelectionColor = color;
				bool $VB$Local_isBold = isBold;
				if ($VB$Local_isBold)
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Bold);
				}
				else
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Regular);
				}
				this.textBuilder.Append(text + " ");
				bool flag = text.EndsWith("\r\n");
				if (flag)
				{
					this.ResultRichTextBox.AppendText(this.textBuilder.ToString().TrimEnd() + Environment.NewLine);
					this.ResultRichTextBox.ScrollToCaret();
					this.textBuilder.Clear();
				}
				this.UpdateRecordCountLabel();
			}
		}

		// Token: 0x060002A0 RID: 672 RVA: 0x00004E60 File Offset: 0x00003060
		private bool CheckForInternetConnection()
		{
			bool result;
			try
			{
				WebRequest webRequest = WebRequest.Create("http://www.google.com");
				WebResponse response = webRequest.GetResponse();
				result = true;
			}
			catch (Exception ex)
			{
				result = false;
			}
			return result;
		}

		// Token: 0x060002A1 RID: 673 RVA: 0x00003689 File Offset: 0x00001889
		private void UpdateRecordCountLabel()
		{
			this.RecordCountLabel.Text = string.Format("Checked: {0}", this.ResultRichTextBox.Lines.Length);
		}

		// Token: 0x060002A2 RID: 674 RVA: 0x000167F4 File Offset: 0x000149F4
		private async void StartButton_Click(object sender, EventArgs e)
		{
			Form6._Closure$__77-0 CS$<>8__locals1 = new Form6._Closure$__77-0(CS$<>8__locals1);
			CS$<>8__locals1.$VB$Me = this;
			bool flag = this.isMining;
			if (!flag)
			{
				CS$<>8__locals1.$VB$Local_selectedCrypto = "";
				bool @checked = this.EthCheckBox.Checked;
				if (@checked)
				{
					CS$<>8__locals1.$VB$Local_selectedCrypto = "BTC";
					bool validCrypto = false;
					bool flag2 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0 || Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
					if (flag2)
					{
						validCrypto = true;
						this.isMining = true;
						this.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.Green, true, 16f);
						await Task.Run(checked(delegate()
						{
							int num = 0;
							while (!CS$<>8__locals1.$VB$Me.cancellationTokenSource.Token.IsCancellationRequested)
							{
								bool flag3 = CS$<>8__locals1.$VB$Me.tries > CS$<>8__locals1.$VB$Me.random.Next(1500, 1000000000);
								if (flag3)
								{
									string text = Form6.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									bool flag4 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0;
									List<string> list;
									int num3;
									unchecked
									{
										if (flag4)
										{
											double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
										}
										else
										{
											bool flag5 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
											if (flag5)
											{
												double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
											}
										}
										list = new List<string>();
										num3 = 0;
									}
									do
									{
										bool flag6 = num3 < CS$<>8__locals1.$VB$Me.words.Length;
										if (flag6)
										{
											list.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										}
										num3++;
									}
									while (num3 <= 11);
									string text2 = string.Format("Wallet check:     {0}", string.Join(" ", list));
									text2 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text2, Color.White, false, 8f);
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.tries = 0;
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.White, false, 8f);
									Thread.Sleep(1);
								}
								else
								{
									string text3 = Form6.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									List<string> list2 = new List<string>();
									int num4 = 0;
									do
									{
										list2.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										num4++;
									}
									while (num4 <= 11);
									string text4 = string.Format("Wallet check:   {0}", string.Join(" ", list2));
									text4 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text4, Color.White, false, 10f);
									Form6 $VB$Me = CS$<>8__locals1.$VB$Me;
									ref int ptr = ref $VB$Me.tries;
									$VB$Me.tries = ptr + 1;
									num++;
								}
							}
						}));
					}
					if (!validCrypto)
					{
						MessageBox.Show("Please choose a valid currency (ETH or BTC).", "Invalid Currency", MessageBoxButtons.OK, MessageBoxIcon.Hand);
					}
				}
				else
				{
					MessageBox.Show("Please select all blockchains.", "Invalid Blockchain", MessageBoxButtons.OK, MessageBoxIcon.Hand);
				}
			}
		}

		// Token: 0x060002A3 RID: 675 RVA: 0x00016638 File Offset: 0x00014838
		private void StopButton_Click(object sender, EventArgs e)
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x060002A4 RID: 676 RVA: 0x0001683C File Offset: 0x00014A3C
		private static string id_gen(int size = 38, string chars = "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789")
		{
			Random random = new Random();
			return new string((from s in Enumerable.Repeat<string>(chars, size)
			select s[random.Next(s.Length)]).ToArray<char>());
		}

		// Token: 0x040001E2 RID: 482
		private CancellationTokenSource cancellationTokenSource;

		// Token: 0x040001E3 RID: 483
		private Random random;

		// Token: 0x040001E4 RID: 484
		private int tries;

		// Token: 0x040001E5 RID: 485
		private bool isMining;

		// Token: 0x040001E7 RID: 487
		private int foundCount;

		// Token: 0x040001E8 RID: 488
		private string[] words;

		// Token: 0x040001E9 RID: 489
		private StringBuilder textBuilder;
	}
}
